TITLE   'Two Wires inside a Magnetic Shield' 		       { exa122b.pde }
SELECT     errlim=1e-4    ngrid=1     spectral_colors		
VARIABLES   Az
DEFINITIONS                      				
   r0=0.05     d0=3*r0     r1=1.0     ra=0.4     rb=0.45     	{ Shield }
   mu0=4*pi*1e-7     mu=mu0     Jz     			{ Current density }
   Bex=dy(Az)     Bey=-dx(Az)
   B=vector( Bex, Bey)     Bm=magnitude( B)
   Hx=Bex/mu     Hy=Bey/mu     H=B/mu     Hm=Bm/mu	
EQUATIONS
   dx( Hy)- dy( Hx)=Jz
BOUNDARIES
region 'domain'  Jz=0       	
   start(-r1,0)   value(Az) =0   arc(center=0,0) angle=360
region 'lower' Jz=  -1.0	
   start (r0,-d0/2)  arc(center=0,-d0/2)  angle=360
region 'upper' Jz= +1.0
   start (r0,d0/2) arc(center=0,d0/2)  angle=360
region 'shield' Jz=0  mu=2500*mu0 		{ Magnetic material }
   start (0,-rb)  arc( center=0,0) angle=+360
   start (0,-ra)  arc( center=0,0) angle=-360
PLOTS
   contour( Bm) log     vector( B) norm
   contour( Bm) painted zoom(-d0,-d0,  2*d0,2*d0)
   elevation( Bm) from (0,-r1) to (0,r1)
   vector( B) norm zoom(-d0,-d0,  2*d0,2*d0)
   elevation( Bm) log from (0,-r1) to (0,r1)
END


